/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于在线升级界面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.8.06
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported  mc_set_get_online_upgrade */


/* global  $*/
/* global  mc_sdk_param*/


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置或读取
 * 参数:
 *    @param {Promise<String>}  str_cmd 硬件读写操作
 *    @param {Promise<String>} str_funk 操作卡函数
 *    @param {Promise<String>} str_order 命令
 *    @param {Promise<String>} obj_rom_json_date 读写地址 写时传字串 读时传false
 *    @param {Promise<String>} str_chip_name 接收卡芯片名称(可空)
 *    @param {Promise<String>} lang 语言
 *    @param {Promise<Function>} fun_callback 回调函数
 * 返回：
 *   @returns {Promise<String>} str_error_date 错误码
 *   @returns {Promise<String>} obj_date.rom 返回读取数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.8.06
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_get_online_upgrade(str_cmd, str_funk, str_order, obj_rom_json_date, str_chip_name, lang, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_cmd(str_cmd);
    obj_sdk_param_req.set_func(str_funk);
    obj_sdk_param_req.set_param_value("POS", str_order);
    if (obj_rom_json_date) {
        obj_sdk_param_req.set_attr_val("POS", "ROM", JSON.stringify(obj_rom_json_date));
    }

    if (str_chip_name) {
        obj_sdk_param_req.set_attr_val("POS", "CHIPNAME", str_chip_name);
    }
    if (!obj_rom_json_date) {
        obj_sdk_param_req.set_attr_val("POS", "LANG", lang);
    }


    $.post("/access_shell", obj_sdk_param_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        var obj_res = new mc_sdk_param();
        var obj_date = {
            chipname: "",
            rom: "",
            lang: "",
            write_check: ""
        };

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");

        obj_date.chipname = obj_res.get_attr_val("POS", "CHIPNAME");
        obj_date.rom = obj_res.get_attr_val("POS", "ROM");
        if ("English" !== obj_res.get_attr_val("POS", "LANG") && "中文" !== obj_res.get_attr_val("POS", "LANG")) {
            obj_date.lang = mc_trans_lang(obj_res.get_attr_val("POS", "LANG"));
        }
        obj_date.write_check = obj_res.get_attr_val("POS", "WRITE_CHECK");
        // var ui_attr_cnt = obj_res.get_attr_cnt("POS")
        // for (var i = 0; i < ui_attr_cnt; i++) {
        //     var str_attr_name_id = obj_res.get_attr_name("POS", i);
        //     if (str_attr_name_id === "ROM") {

        //     }

        // }


        fun_callback(str_error_date, obj_date);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换语言表
 * 参数:
 *    @param {Promise<string>} str_lang_json 传入需要转换的语言解释表json字串,不能为空
 * 返回：
 *    @returns {Promise<string>} 转换为需要的语言解释表对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.11.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_trans_lang(str_lang_json) {
    if ("string" !== typeof str_lang_json || 0 >= str_lang_json.length) {
        return "";
    }
    var str_item_json_req = new mc_sdk_param();
    var obj_language = {};

    str_item_json_req.set_param_clear();
    str_item_json_req.set_json(str_lang_json);
    var ui_param_cnt = str_item_json_req.get_param_cnt();
    var str_pamay_val = "";
    var str_pamay_name = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_item_json_req.get_param_name(idx_param);
        str_pamay_val = str_item_json_req.get_param_value(str_pamay_name);
        obj_language[str_pamay_name] = str_pamay_val;
    }
    return obj_language;
}
